//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "MdiFrame.h"
#include "cpm_test.h"
#include <string.h>
#include "MkfsUnit.h"
#include <shlobj.h>
#include <stdlib.h>
#include <dir.h>
#include "AboutDlg.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TFrameForm *FrameForm;
extern char defpath[];
extern char cur_defpath[];
char tmp_dir[MAX_PATH];
AnsiString fmt;

//hbOhbviC[Woj---------------------------------
// IDropSource̎
class TDropSource : public IDropSource
{
public:
  TDropSource() : FRefCount(0) {
  }
  HRESULT __stdcall QueryInterface(REFIID riid, void** ppv)
  {
    IUnknown *punk = NULL;
    if (riid == IID_IUnknown) {
      punk = static_cast<IUnknown*>(this);
    } else if (riid == IID_IDropSource) {
      punk = static_cast<IDropSource*>(this);
    }

    *ppv = punk;
    if (punk) {
      punk->AddRef();
      return S_OK;
    } else {
      return E_NOINTERFACE;
    }
  }
  ULONG __stdcall AddRef()
  {
    InterlockedIncrement(&FRefCount);
    return (ULONG)FRefCount;
  }
  ULONG __stdcall Release()
  {
    ULONG ret = (ULONG)InterlockedDecrement(&FRefCount);
    if (ret == 0) {
      delete this;
    }
    return ret;
  }

  /**
   * hbOAhhbvp邩I邩Ԃ܂B
   */
  HRESULT __stdcall QueryContinueDrag(BOOL fEsc, DWORD grfKeyState)
  {
    // ESCꂽÃ{^Ăꍇ͒~
    if (fEsc ||
        (MK_LBUTTON | MK_RBUTTON) == (grfKeyState & (MK_LBUTTON | MK_RBUTTON))) {
      return DRAGDROP_S_CANCEL;
    }

    //}EX̍{^ꂽꍇ̓hbv
    if ((grfKeyState & (MK_LBUTTON | MK_RBUTTON)) == 0) {
      return DRAGDROP_S_DROP;
    }

    //ȊOD&Dp
    return S_OK;
  }

  /**
   * }EXJ[\̌`ݒ肵A[U[ɃtB[hobN񋟂܂B
   */
  HRESULT __stdcall GiveFeedback(DWORD dwEffect)
  {
    //ftHg̃J[\g
    return DRAGDROP_S_USEDEFAULTCURSORS;
  }
private:
  LONG FRefCount;
};

//---------------------------------------------------------------------------
__fastcall TFrameForm::TFrameForm(TComponent* Owner)
	: TForm(Owner)
{
    strcpy(defpath, GetCurrentDir().c_str());
    strcpy(tmp_dir, defpath);
    strcat(defpath, "\\diskdefs");
    strcat(tmp_dir, "\\Cpmtools_tmp");

    //hbOŎ󂯎\
    DragAcceptFiles(Edit1->Handle, true );
    DragAcceptFiles(ListView1->Handle, true );

    Application->OnMessage = AppMessage; //bZ[W֐w

    OleInitialize(NULL);

}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Exit1Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Open1Click(TObject *Sender)
{
	if(OpenFileDialog->Execute())
    {
        Edit1->Text = OpenFileDialog->FileName;
    }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::cpm_ls(char image[], char format[], char pat[])
{
    int dir_count=0;
    char **dir_name;
    const char *err;

    err=cpm_ls_test(image, format, pat, &dir_count, &dir_name);
    if(err!=NULL){
		//G[
        MessageBox(Handle, err, "Message Box", MB_OK);
        ListView1->Items->Clear();
        free(dir_name);
        return;
    }

    int i;
    ListView1->Items->Clear();
    for(i=0; i<dir_count; i++){
        ListView1->Items->Add();
        ListView1->Items->Item[i]->Caption = String(dir_name[i]+2);
    }
    free(dir_name);
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::ComboBox1Change(TObject *Sender)
{
	cpm_ls(Edit1->Text.c_str(),fmt.c_str(), ComboBox1->Text.c_str());
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::Button1Click(TObject *Sender)
{
	if(OpenFileDialog->Execute())
    {
    	strcpy(cur_defpath, GetCurrentDir().c_str());
	    strcat(cur_defpath, "\\diskdefs");

        Edit1->Text = OpenFileDialog->FileName;
    }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Edit1Change(TObject *Sender)
{
    cpm_fmt();
    fmt = ListBox1->Items->Strings[ListBox1->ItemIndex];
	cpm_ls(Edit1->Text.c_str(),fmt.c_str(), ComboBox1->Text.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::cpm_fmt()
{
    int fmt_count=0;
    char **fmt_name;
    const char *err;

    err=cpm_fmt_test(&fmt_count, &fmt_name);
    if(err!=NULL){
    	//G[
        MessageBox(Handle, err, "Message Box", MB_OK);
        free(fmt_name);
        exit(1);
    }
    int i;
    ListBox1->Items->Clear();
    for(i=0; i<fmt_count; i++){
        ListBox1->Items->Add(String(fmt_name[i]));
    }
    ListBox1->ItemIndex = 0;
    free(fmt_name);
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::ListBox1Click(TObject *Sender)
{
	fmt = ListBox1->Items->Strings[ListBox1->ItemIndex];
    cpm_ls(Edit1->Text.c_str(),fmt.c_str(), ComboBox1->Text.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::BitBtn1Click(TObject *Sender)
{
	int i;
    AnsiString src, dest;
    const char *err;

    for(i=0; i< ListView1->Items->Count; i++){
    	if(ListView1->Items->Item[i]->Selected){
        	src = ListView1->Items->Item[i]->Caption;
            dest = DirectoryListBox1->Directory + String("\\") + src;
            if(FileExists(dest)){
            	if(MessageBox(Handle, "㏑܂",
                                   src.c_str(), MB_YESNO)==IDNO) continue;
            }
            err=cpm_to_win_test(Edit1->Text.c_str(),fmt.c_str(),src.c_str() ,dest.c_str());
            if(err!=NULL){  //G[
            	MessageBox(Handle, err, dest.c_str(), MB_OK);
            	//MessageBox(Handle, err, "Message Box", MB_OK);
                //return;
            }
        }
    }
    FileListBox1->Update();
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::BitBtn2Click(TObject *Sender)
{
	int i;
    AnsiString src, dest;
    const char *err;

    if(Edit1->Text.Length()==0) return;

    for(i=0; i< FileListBox1->Items->Count; i++){
    	if(FileListBox1->Selected[i]){
        	dest = FileListBox1->Items->Strings[i];
            src = DirectoryListBox1->Directory + String("\\") + dest;
            err=win_to_cpm_test(Edit1->Text.c_str(),fmt.c_str(),src.c_str() ,dest.c_str());
            if(err!=NULL){  //G[
            	MessageBox(Handle, err, dest.c_str(), MB_OK);
            	//MessageBox(Handle, err, "Message Box", MB_OK);
                //return;
            }

        }
    }
    cpm_ls(Edit1->Text.c_str(),fmt.c_str(), ComboBox1->Text.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Delete1Click(TObject *Sender)
{
	int i;
    AnsiString src;
    const char *err;

	if(MessageBox(Handle, "It@C폜܂",
                                   "mF", MB_YESNO)==IDYES)
    {
    	for(i=0; i< ListView1->Items->Count; i++){
    		if(ListView1->Items->Item[i]->Selected){
        		src = ListView1->Items->Item[i]->Caption;
            	err=cpm_rm_test(Edit1->Text.c_str(),fmt.c_str(),src.c_str());
            	if(err!=NULL){  //G[
            		MessageBox(Handle, err, src.c_str(), MB_OK);
            		//MessageBox(Handle, err, "Message Box", MB_OK);
                	//break;
            	}
        	}
    	}
    	cpm_ls(Edit1->Text.c_str(),fmt.c_str(), ComboBox1->Text.c_str());
    }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::PopupMenu1Popup(TObject *Sender)
{
    if(ListView1->SelCount) Delete1->Enabled=true;
    else Delete1->Enabled=false;
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::FormCreate(TObject *Sender)
{
	if(ParamCount()){
	    strcpy(cur_defpath, ParamStr(1).c_str());
        *strrchr(cur_defpath, '\\')='\0';
        strcat(cur_defpath, "\\diskdefs");

    	Edit1->Text =  ParamStr(1);
    }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::BitBtn3Click(TObject *Sender)
{
	  Close();
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Mkfs1Click(TObject *Sender)
{
	MkfsForm->ShowModal();
}
//---------------------------------------------------------------------------
//hbO&hbv(Õt@CR|[lg)
void __fastcall TFrameForm::WMDropFiles( TWMDropFiles &Msg, HWND hwnd )
{
    // ϐ錾
    int FileCount;              //󂯎t@C
    char FileName[ MAX_PATH ];  //t@Cꎞۑ
    Application->BringToFront();   //AvP[VOʂɈړ

    // t@C𓾂
    FileCount = (int)DragQueryFile( (HDROP)Msg.Drop , 0xFFFFFFFF , NULL , MAX_PATH );

    if(hwnd == Edit1->Handle){  //tH[փC[Wt@C̃hbO&hbv
       	if(FileCount > 1) goto WMD_END;
    	DragQueryFile((HDROP)Msg.Drop, 0, FileName, MAX_PATH ); //t@CpX𓾂
	   	strcpy(cur_defpath, FileName);
       	*strrchr(cur_defpath, '\\')='\0';
       	strcat(cur_defpath, "\\diskdefs");
       	Edit1->Text = FileName;
    }

    if(hwnd == ListView1->Handle){  //C[WCP/Mt@C̃hbO&hbv
	    for( int i=0 ; i < FileCount ; ++i ){
		    AnsiString src, dest;
		    const char *err;

    	    DragQueryFile((HDROP)Msg.Drop, i, FileName, MAX_PATH ); //t@CpX𓾂
            if(ExtractFileDir(String(FileName)) == String(tmp_dir)){
                 remove(FileName);
            	 continue;
            }
            dest = strrchr(FileName, '\\')+1;
            src = FileName;
            err=win_to_cpm_test(Edit1->Text.c_str(),fmt.c_str(),src.c_str() ,dest.c_str());
            if(err!=NULL){  //G[
            	MessageBox(Handle, err, dest.c_str(), MB_OK);
            	//MessageBox(Handle, err, "Message Box", MB_OK);
                //goto WMD_END;
            }
         }
         cpm_ls(Edit1->Text.c_str(),fmt.c_str(), ComboBox1->Text.c_str());
    }
    WMD_END:
    DragFinish((HDROP)Msg.Drop);
    Msg.Result = true;//falseȂ΁ÃRg[ł\邪falsełǂB
}
//---------------------------------------------------------------------------
//AvP[ṼbZ[W[v𑀍삷֐
void __fastcall TFrameForm::AppMessage(tagMSG &Msg, bool &Handled)
{
    if (Msg.message == WM_DROPFILES && (Msg.hwnd == Edit1->Handle ||
                                        Msg.hwnd == ListView1->Handle ))
    {
        //MsgTWMDropFiles\̂̌`ɍ킹ĕό`
        TWMDropFiles MsgDrop;
        MsgDrop.Drop = Msg.wParam;
        WMDropFiles(MsgDrop, Msg.hwnd);
        Handled=MsgDrop.Result;
    }
    if (Msg.message == WM_DROPFILES && (Msg.hwnd == MkfsForm->Edit1->Handle ||
                                        Msg.hwnd == MkfsForm->Edit2->Handle ||
                                        Msg.hwnd == MkfsForm->Edit3->Handle ||
                                        Msg.hwnd == MkfsForm->Edit4->Handle ||
                                        Msg.hwnd == MkfsForm->Edit5->Handle ))
    {
        //MsgTWMDropFiles\̂̌`ɍ킹ĕό`
        TWMDropFiles MsgDrop;
        MsgDrop.Drop = Msg.wParam;
        MkfsForm->WMDropFiles(MsgDrop, Msg.hwnd);
        Handled=MsgDrop.Result;
    }
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	OleUninitialize();
}
//---------------------------------------------------------------------------
/**
 * ƃtH_t@CIDataObjectC^[tFCX擾
 * @param selcount t@C
 * @return sƂNULL
 */
IDataObject *GetFilePathDataObject(int selcount)
{

  OLECHAR  olePath[MAX_PATH];

  //fXNgbvIShellFolderC^[tFCX擾
  IShellFolder* desktop = NULL;
  if (FAILED(SHGetDesktopFolder(&desktop))) { return NULL; }

  //Ώۃt@C̐etH_(ƃtH_)̍ڎʎq𓾂
  ITEMIDLIST* dirIDList;
  DWORD eaten = 0, attributes = 0;

  MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, tmp_dir, -1, olePath, MAX_PATH);
  if (FAILED(desktop->ParseDisplayName(NULL, NULL, olePath, &eaten,
                                       &dirIDList, &attributes))) {
    desktop->Release();
    return NULL;
  }

  //etH_IShellFolderC^[tFCX擾
  IShellFolder* targetFolder;
  if (FAILED(desktop->BindToObject(dirIDList, NULL, IID_IShellFolder,
                                   (void**)&targetFolder))) {
    desktop->Release();
    return NULL;
  }
  //m
  LPITEMIDLIST *ppidlAbsolute;
  ppidlAbsolute = (LPITEMIDLIST *)CoTaskMemAlloc(sizeof(LPITEMIDLIST) * selcount);

  int i,j=0;
  AnsiString file;

  for(i=0; i< FrameForm->ListView1->Items->Count; i++){
  	if(FrameForm->ListView1->Items->Item[i]->Selected){
    	file = FrameForm->ListView1->Items->Item[i]->Caption;
        //Ώۃt@C̍ڎʎq𓾂
  		MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, file.c_str(), -1, olePath, MAX_PATH);
  		if (FAILED(targetFolder->ParseDisplayName(NULL, NULL, olePath, &eaten,
                                            &ppidlAbsolute[j], &attributes))) {
    		targetFolder->Release();
    		desktop->Release();
    		return NULL;
  		}
        j++;
    }
  }

  //f[^IuWFNg擾
  IDataObject* dataObject = NULL;
  targetFolder->GetUIObjectOf(NULL, selcount, (LPCITEMIDLIST*)ppidlAbsolute,
                              IID_IDataObject, NULL, (void**)&dataObject);

  //n
  for (i = 0; i < selcount; i++)
		CoTaskMemFree(ppidlAbsolute[i]);
  CoTaskMemFree(ppidlAbsolute);

  targetFolder->Release();
  desktop->Release();
  
  return dataObject;
}
//---------------------------------------------------------------------------

void __fastcall TFrameForm::ListView1MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
  if (Button == mbLeft) {
    FMouseDownPt.x = X;
    FMouseDownPt.y = Y;
    Perform(WM_LBUTTONUP, 0, 0);
  }
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::ListView1MouseMove(TObject *Sender,
	TShiftState Shift, int X, int Y)   //C[WohbOhbv
{
  //{^ꂽԂŁA}EẌʒu臒l𒴂hbOJn
  if ((Shift.Contains(ssLeft) == false) ||
          (abs(X - FMouseDownPt.x) < 3) ||
          (abs(Y - FMouseDownPt.y) < 3)  ) {
      return;
  }
  //ƃtH_쐬
  if(!DirectoryExists(String(tmp_dir))){
  	mkdir(tmp_dir);
  }
  //C[Wot@CƃtH_ɍ쐬
  int i,j=0;
  AnsiString src, dest;
  const char *err;

  for(i=0; i< ListView1->Items->Count; i++){
  	if(ListView1->Items->Item[i]->Selected){
    	src = ListView1->Items->Item[i]->Caption;
        dest = String(tmp_dir) + String("\\") + src;
        err=cpm_to_win_test(Edit1->Text.c_str(),fmt.c_str(),src.c_str() ,dest.c_str());
        if(err!=NULL){  //G[
        	MessageBox(Handle, err, src.c_str(), MB_OK);
        	//MessageBox(Handle, err, "Message Box", MB_OK);
            //return;
        }
        j++;
    }
  }
  // OLEhbOhbvJn
  IDataObject* dataObject = GetFilePathDataObject(j);
  if (dataObject == NULL) {
  	return;
  }
  DWORD dropEffect;
  TDropSource* dropSource = new TDropSource();
  dropSource->AddRef();
  DoDragDrop(dataObject, dropSource, DROPEFFECT_COPY, &dropEffect);
  dataObject->Release();
  dropSource->Release();

  //ƃtH_̃t@C폜
  for(i=0; i< ListView1->Items->Count; i++){
  	if(ListView1->Items->Item[i]->Selected){
    	src = ListView1->Items->Item[i]->Caption;
        dest = String(tmp_dir) + String("\\") + src;
        remove(dest.c_str());
    }
  }
  rmdir(tmp_dir);

}
//---------------------------------------------------------------------------


void __fastcall TFrameForm::Edit2Click(TObject *Sender)
{
	//ListView1->SetFocus();

    if(ListView1->SelCount && ListView1->Focused()) Delete2->Enabled=true;
    else Delete2->Enabled=false;

    if(ListView1->SelCount) imgGet1->Enabled=true;
    else imgGet1->Enabled=false;
    
    if(FileListBox1->SelCount) imgPut1->Enabled=true;
    else imgPut1->Enabled=false;

}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::About1Click(TObject *Sender)
{
     About->ShowModal();	
}
//---------------------------------------------------------------------------
void __fastcall TFrameForm::Online1Click(TObject *Sender)
{
	//EFuuEUŎwURLJ
	AnsiString url = "http://star.gmobb.jp/koji/cgi/wiki.cgi?page=CpmtoolsGUI";
	ShellExecute(0, "open", url.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
