;    CP/M BIOS for avrcpm
;    Copyright (C) 2010 Sprite_tm
;
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.


CON_STS:		equ	$80
CON_IN:			equ	$81
CON_OUT:		equ	$82
TRACK_SEL_L: 		equ	$A0
TRACK_SEL_H:		equ	$A1
SECTOR_SEL:		equ	$A2
ADR_L:			equ	$A4
ADR_H:			equ	$A5
EXEC_DMA:		equ	$A6
DMA_RS:			equ	$A7

msize:	equ	62	;size of available RAM in k

bias:	equ	(msize-20) * 1024 
ccp:	equ	$3400+bias	;base of cpm ccp
bdos:	equ	ccp+$806	;base of bdos
bios:	equ	ccp+$1600	;base of bios
cdisk:	equ	$0004		;current disk number (0 ... 15)
iobyte:	equ	$0003		;intel iobyte
buff:	equ	$0080		;default buffer address
retry:	equ	3		;max retries on disk i/o before error

cr:	equ	13
lf:	equ	10

	org	bios
nsects:	equ	($-ccp)/128	;warm start sector count
	
	jp boot
wboote:	
	jp wboot
	jp const
	jp conin
	jp conout
	jp list
	jp punch
	jp reader
	jp home
	jp seldsk
	jp settrk
	jp setsec
	jp setdma
	jp read
	jp write
	jp listst
	jp sectran

signon:
	db	cr,lf
	db	msize/10+'0'
	db	msize - (msize/10)*10 + '0'	;modulo doesn't work?
	db	"k CP/M vers 2.2"
	db	cr,lf,0

boot:
	ld	sp,buff
	ld	hl,signon
	call	prmsg
	xor	a
	ld	(iobyte),a
	ld	(cdisk),a
	ld	(odisk),a	;add neko Java 2011.7.27
	jp	gocpm 

wboot:	;re-load CP/M
	ld	sp,buff
	ld	c,0
	call	seldsk
	call	home
	ld	b,nsects
	ld	c,0		;track
	ld	d,1		;sektor (0 based)
	ld	hl,ccp
load1:
	push	bc
	push	de
	push	hl
	ld	c,d
	call	setsec
	pop	bc
	push	bc
	call	setdma
	call	read
	cp	0		;read error?
	jp	nz,wboot
	
	pop	hl
	ld	de,128
	add	hl,de
	pop	de
	pop	bc
	dec	b
	jp	z,gocpm
	
	inc	d
	ld	a,d
	cp	64	;if sector >= 64 then change tracks. mod neko Java 2011.7.19
	jp	c,load1
	
	ld	d,0
	inc	c
	push	bc
	push	de
	push	hl
	ld	b,0	;add neko Java 2011.7.19
	call	settrk
	pop	hl
	pop	de
	pop	bc
	jp	load1
	
gocpm:
	ld	a,0c3h
	ld	(0),a
	ld	hl,wboote
	ld	(1),hl
	ld	(5),a
	ld	hl,bdos
	ld	(6),hl
		
	ld	bc,buff
	call	setdma
	ld	a,(cdisk)
	ld	c,a
	jp	ccp

const:
	in a,(CON_STS)
	ret

conin:
	in a,(CON_STS)
	cp $ff
	jp nz,conin

	in a,(CON_IN)
	ret

conout:
	ld a,c
	out (CON_OUT),a
	ret

list:
	ret

listst:
	ld a,0
	ret

punch:
	ret

reader:
	ld a,$1F
	ret

home:
	push af
	ld a,0
	out (TRACK_SEL_L),a
	out (TRACK_SEL_H),a	;add neko Java 2011.7.19
	pop af
	ret

seldsk:			;mod for 4drive. neko Java 2011.7.27
	push af
	ld a,c
	cp 0
	jr nz,seldsk_1
	ld hl,dph0
	jr seldsk_ok
seldsk_1:
	cp 1
	jr nz,seldsk_2
	ld hl,dph1
	jr seldsk_ok
seldsk_2:
	cp 2
	jr nz,seldsk_3
	ld hl,dph2
	jr seldsk_ok
seldsk_3:
	cp 3
	jr nz,seldsk_na
	ld hl,dph3
seldsk_ok:
	ld (odisk),a
	pop af
	ret
seldsk_na:
	ld hl,0
	ld a,(odisk)
	ld (cdisk),a
	pop af
	ret

settrk:
	push af
	ld a,c
	out (TRACK_SEL_L),a
	ld a,b			;add neko Java 2011.7.19
	out (TRACK_SEL_H),a	;add neko Java 2011.7.19
	pop af
	ret

setsec:
	push af
	ld a,c
	out (SECTOR_SEL),a
	pop af
	ret

setdma:
	push af
	ld a,c
	out (ADR_L),a
	ld a,b
	out (ADR_H),a
	pop af
	ret

read:
	ld a,1
	out (EXEC_DMA),a
	in a,(DMA_RS)	;mod neko Java
	ret

write:
	ld a,2
	out (EXEC_DMA),a
	in a,(DMA_RS)	;mod neko Java
	ret

sectran:
	;translate sector bc using table at de, res into hl
	;not implemented :)
	ld h,b
	ld l,c
	ret

prmsg:
	ld	a,(hl)
	or	a
	ret	z
	push	hl
	ld	c,a
	call	conout
	pop	hl
	inc	hl
	jp	prmsg
	

;Disk Parameter Header
dph0:
	dw trans ;XLT: Address of translation table
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw dirbuf ;DIRBUF: Address of a dirbuff scratchpad
	dw dpb0 ;DPB: Address of a disk parameter block
	dw chk0 ;CSV: Address of scratchpad area for changed disks
	dw all0 ;ALV: Address of an allocation info scratchpad

dph1:
	dw trans ;XLT: Address of translation table
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw dirbuf ;DIRBUF: Address of a dirbuff scratchpad
	dw dpb1 ;DPB: Address of a disk parameter block
	dw chk1 ;CSV: Address of scratchpad area for changed disks
	dw all1 ;ALV: Address of an allocation info scratchpad

dph2:
	dw trans ;XLT: Address of translation table
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw dirbuf ;DIRBUF: Address of a dirbuff scratchpad
	dw dpb2 ;DPB: Address of a disk parameter block
	dw chk2 ;CSV: Address of scratchpad area for changed disks
	dw all2 ;ALV: Address of an allocation info scratchpad
dph3:
	dw trans ;XLT: Address of translation table
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw 0 ;000: Scratchpad
	dw dirbuf ;DIRBUF: Address of a dirbuff scratchpad
	dw dpb3 ;DPB: Address of a disk parameter block
	dw chk3 ;CSV: Address of scratchpad area for changed disks
	dw all3 ;ALV: Address of an allocation info scratchpad

dpb0:
	dw 64 ;SPT: sectors per track
	db 4 ;BSH: data allocation block shift factor
	db 15 ;BLM: Data Allocation Mask
	db 0 ;Extent mask
	dw 971 ;DSM: Disk storage capacity
	dw 127 ;DRM, no of directory entries
	db 192 ;AL0
	db 0 ;AL1
	dw 32 ;CKS, size of dir check vector
	dw 1 ;OFF, no of reserved tracks

dpb1:
	dw 64 ;SPT: sectors per track
	db 4 ;BSH: data allocation block shift factor
	db 15 ;BLM: Data Allocation Mask
	db 0 ;Extent mask
	dw 975 ;DSM: Disk storage capacity
	dw 127 ;DRM, no of directory entries
	db 192 ;AL0
	db 0 ;AL1
	dw 32 ;CKS, size of dir check vector
	dw 244 ;OFF, no of reserved tracks

dpb2:
	dw 64 ;SPT: sectors per track
	db 4 ;BSH: data allocation block shift factor
	db 15 ;BLM: Data Allocation Mask
	db 0 ;Extent mask
	dw 975 ;DSM: Disk storage capacity
	dw 127 ;DRM, no of directory entries
	db 192 ;AL0
	db 0 ;AL1
	dw 32 ;CKS, size of dir check vector
	dw 488 ;OFF, no of reserved tracks
dpb3:
	dw 64 ;SPT: sectors per track
	db 4 ;BSH: data allocation block shift factor
	db 15 ;BLM: Data Allocation Mask
	db 0 ;Extent mask
	dw 975 ;DSM: Disk storage capacity
	dw 127 ;DRM, no of directory entries
	db 192 ;AL0
	db 0 ;AL1
	dw 32 ;CKS, size of dir check vector
	dw 732 ;OFF, no of reserved tracks

trans:
	db 0

dirbuf:
	ds 128

chk0:
	ds 32

chk1:
	ds 32

chk2:
	ds 32

chk3:
	ds 32

all0:
	ds 122

all1:
	ds 122

all2:
	ds 122

all3:
	ds 122

odisk:
	ds 1	;add neko Java 2011.7.27

;end
