;    CP/M IPL for avrcpm
;    Copyright (C) 2010 Sprite_tm
;
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.

CON_IN:			equ	$81
CON_OUT:		equ	$82
TRACK_SEL_L: 		equ	$A0
TRACK_SEL_H:		equ	$A1
SECTOR_SEL:		equ	$A2
ADR_L:			equ	$A4
ADR_H:			equ	$A5
EXEC_DMA:		equ	$A6

org $2000
	; IPL for the CP/M-emu in an AVR. Loads CPM from the 'disk' from
	; track 0 sector 2 to track 1 sector 26.

	ld sp,$1000
	
	call printipl


	ld b,55		;mod neko Java 2011.7.20
	ld de,$0001
	ld hl,$3400+$A800
loadloop:
	ld a,d ;track
	out (TRACK_SEL_L),a
	out (TRACK_SEL_H),a
	ld a,e ; sector (base-0)
	out (SECTOR_SEL),a
	ld a,l ;dma L
	out (ADR_L),a
	ld a,h ;dma H
	out (ADR_H),a
	ld a,1
	out (EXEC_DMA),a

	push bc
	ld bc,$80
	add hl,bc
	pop bc

	inc e
	ld a,e
	;cp 26
	cp 64			;mod to 64 sector. neko Java 2011.7.20
	jp nz,noNextTrack

	inc d
	ld e,0

noNextTrack:

	dec b
	jp nz,loadloop

	jp $4A00+$A800

printipl:
	ld a,'i'
	out (CON_OUT),a
	ld a,'p'
	out (CON_OUT),a
	ld a,'l'
	out (CON_OUT),a
	ld a,13
	out (CON_OUT),a
	ld a,10
	out (CON_OUT),a
	ret

;end
